import numpy as np
import Utilities.waveform_creator as wc
import matplotlib.pyplot as plt

num = 1024
samp_freq = 2000

t = wc.create_time_data(num, samp_freq)
y = np.cos(2*np.pi*250*t)
#y = np.sin(2*np.pi*250*t)
#y = np.cos(2*np.pi*250*t + np.pi/6)

freq, complex_amp = wc.fft_complex(y, num, samp_freq)

phase = np.angle(complex_amp)

for i in range(num):
    if np.abs(complex_amp[i]) < 0.05:
       phase[i] = 0

#phase[np.abs(complex_amp) < 0.05] = 0

plt.plot(freq,phase)
plt.show()
